<?php

use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\IncomeController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\MembershipTypeController;
use App\Http\Controllers\MembershipController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\UserRoleController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\SetupController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|   
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::middleware(['auth', 'check_permission', 'setup', 'locale'])->group(function () {
    // User Routes
    Route::resource('user', ProfileController::class);
    Route::match(['get', 'post'], 'users', [ProfileController::class, 'index'])->name('user.index');
    Route::get('profile/{user}', [ProfileController::class, 'profile'])->name('user.profile');
    Route::patch('profile/update-profile/{user}', [ProfileController::class, 'update_profile'])->name('user.update_profile');

    // Member Routes
    Route::resource('member', MemberController::class);
    Route::match(['get', 'post'], 'members', [MemberController::class, 'index'])->name('member.index');
    Route::match(['get', 'post'], 'members/unpaid', [MemberController::class, 'unpaid'])->name('member.unpaid');
    Route::match(['get', 'post'], 'members/expired', [MemberController::class, 'expired'])->name('member.expired');

    // Membership Type Routes
    Route::resource('plan', MembershipTypeController::class);
    Route::match(['get', 'post'], 'plans', [MembershipTypeController::class, 'index'])->name('plan.index');

    // Membership Routes
    Route::resource('membership', MembershipController::class);
    Route::match(['get', 'post'], 'memberships', [MembershipController::class, 'index'])->name('membership.index');
    Route::get('memberships/create/{id?}', [MembershipController::class, 'create'])->name('membership.create');

    // Income Routes
    Route::resource('income', IncomeController::class);
    Route::match(['get', 'post'], 'incomes', [IncomeController::class, 'index'])->name('income.index');
    
    // Expense Routes
    Route::resource('expense', ExpenseController::class);
    Route::match(['get', 'post'], 'expenses', [ExpenseController::class, 'index'])->name('expense.index');

    // Transaction Routes
    Route::resource('transaction', TransactionController::class);
    Route::get('transactions/create/{id}', [TransactionController::class, 'create'])->name('transaction.create');

    // Settings Routes
    Route::get('settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('settings/store', [SettingsController::class, 'store'])->name('settings.store');
    Route::post('settings/update-logo', [SettingsController::class, 'update_logo'])->name('settings.update_logo');
    Route::post('settings/remove-logo', [SettingsController::class, 'remove_logo'])->name('settings.remove_logo');
    Route::post('settings/fetch-logo', [SettingsController::class, 'fetch_logo'])->name('settings.fetch_logo');

    // User Role Routes
    Route::resource('user_role', UserRoleController::class);
    Route::match(['get', 'post'], 'user_roles', [UserRoleController::class, 'index'])->name('user_role.index');

    // Attendance Routes
    Route::resource('attendance', AttendanceController::class);
    Route::get('attendances', [AttendanceController::class, 'index'])->name('attendance.index');
    Route::match(['get', 'post'], 'attendances/manual', [AttendanceController::class, 'create'])->name('attendance.create');
    Route::post('attendances', [AttendanceController::class, 'store_manual'])->name('attendance.store_manual');

    // Invoice Routes
    Route::get('invoice/show/{id}', [InvoiceController::class, 'show'])->name('invoice.show');
    Route::get('invoice/print/{id}', [InvoiceController::class, 'print'])->name('invoice.print');

    // Reports Routes
    Route::match(['get', 'post'], 'reports/member', [ReportsController::class, 'member_information'])->name('reports.member_information');
    Route::match(['get', 'post'], 'reports/payments', [ReportsController::class, 'payment_transactions'])->name('reports.payment_transactions');
    Route::match(['get', 'post'], 'reports/attendance', [ReportsController::class, 'attendance'])->name('reports.attendance');
});

/**
 * Dashboard route is outside the group because 
 * we do not want the permission middleware to be applied on it.
 * */ 
Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['auth', 'verified', 'setup', 'locale'])->name('dashboard');

// Initial entry point of the application
if (env('APP_INSTALLED', true)) {
    Route::get('/', function () {
        return redirect('/login');
    });
} else {
    Route::get('/', function () {
        return redirect('/setup');
    });
}

// App Installation Setup Routes
Route::get('/setup', [SetupController::class, 'index'])->name('setup');
Route::get('/setup/database/{status?}', [SetupController::class, 'database'])->name('setup.database');
Route::post('/setup/setup_database', [SetupController::class, 'setup_database'])->name('setup.setup_database');
Route::get('/setup/migrations', [SetupController::class, 'migrations'])->name('setup.migrations');
Route::get('/setup/user', [SetupController::class, 'user'])->name('setup.user');
Route::post('/setup/create_user/{user?}', [SetupController::class, 'create_user'])->name('setup.create_user');
 
require __DIR__ . '/auth.php';